<?php
require_once __DIR__ . "/config.php";

$id = (int)($_GET['id'] ?? 0);
$stmt = $pdo->prepare("SELECT * FROM song_jobs WHERE id=?");
$stmt->execute([$id]);
$job = $stmt->fetch();

if (!$job) { http_response_code(404); exit("Job not found."); }
?>
<!doctype html>
<html lang="de">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>SongAI – Job #<?=h((string)$job['id'])?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-5">
  <div class="row justify-content-center">
    <div class="col-lg-9">
      <div class="card shadow-sm border-0">
        <div class="card-body p-4">
          <div class="d-flex justify-content-between align-items-start">
            <div>
              <h4 class="mb-1">🎧 <?=h((string)$job['title'])?></h4>
              <div class="text-muted">Job #<?=h((string)$job['id'])?> • Stil: <?=h((string)$job['style'])?> • Tempo: <?=h((string)$job['tempo'])?> BPM</div>
            </div>
            <a class="btn btn-outline-secondary btn-sm" href="status.php">Alle Jobs</a>
          </div>

          <hr class="my-4">

          <div class="mb-3">
            <div class="badge bg-secondary" id="statusBadge"><?=h((string)$job['status'])?></div>
            <div class="mt-2">
              <div class="progress" style="height: 14px;">
                <div class="progress-bar" id="progressBar" role="progressbar" style="width: <?= (int)$job['progress'] ?>%"></div>
              </div>
              <div class="text-muted small mt-2" id="progressText"><?= (int)$job['progress'] ?>%</div>
            </div>
          </div>

          <div id="resultArea">
            <?php if ($job['status'] === 'done' && $job['result_url']): ?>
              <a class="btn btn-success" href="<?=h((string)$job['result_url'])?>" target="_blank">⬇ Download MP3</a>
            <?php elseif ($job['status'] === 'failed'): ?>
              <div class="alert alert-danger mb-0">
                Fehler: <?=h((string)($job['error_message'] ?? 'Unknown error'))?>
              </div>
            <?php else: ?>
              <div class="text-muted">Bitte warten… Generierung läuft.</div>
            <?php endif; ?>
          </div>

        </div>
      </div>

      <div class="text-center text-muted small mt-3">
        Seite aktualisiert automatisch, bis der Song fertig ist.
      </div>
    </div>
  </div>
</div>

<script>
async function poll() {
  const res = await fetch("status.php?json=1&id=<?= (int)$job['id'] ?>", {cache: "no-store"});
  if (!res.ok) return;
  const data = await res.json();

  document.getElementById("statusBadge").className =
    "badge " + (data.status === "done" ? "bg-success" : data.status === "failed" ? "bg-danger" : "bg-secondary");
  document.getElementById("statusBadge").textContent = data.status;

  document.getElementById("progressBar").style.width = data.progress + "%";
  document.getElementById("progressText").textContent = data.progress + "%";

  const resultArea = document.getElementById("resultArea");
  if (data.status === "done" && data.result_url) {
    resultArea.innerHTML = `<a class="btn btn-success" href="${data.result_url}" target="_blank">⬇ Download MP3</a>`;
    return;
  }
  if (data.status === "failed") {
    resultArea.innerHTML = `<div class="alert alert-danger mb-0">Fehler: ${data.error_message || "Unknown error"}</div>`;
    return;
  }
  setTimeout(poll, 2000);
}
poll();
</script>
</body>
</html>
