CREATE TABLE users (
  id INT AUTO_INCREMENT PRIMARY KEY,
  email VARCHAR(190) NOT NULL UNIQUE,
  password_hash VARCHAR(255) NOT NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE song_jobs (
  id BIGINT AUTO_INCREMENT PRIMARY KEY,
  user_id INT NULL,
  title VARCHAR(190) NOT NULL,
  lyrics MEDIUMTEXT NOT NULL,
  style VARCHAR(100) DEFAULT NULL,
  tempo INT DEFAULT NULL,
  status ENUM('queued','processing','done','failed') NOT NULL DEFAULT 'queued',
  progress TINYINT NOT NULL DEFAULT 0,
  result_url VARCHAR(500) DEFAULT NULL,
  error_message VARCHAR(500) DEFAULT NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  INDEX (status),
  INDEX (user_id),
  CONSTRAINT fk_song_jobs_user FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE SET NULL
);
