<?php
require_once __DIR__ . "/config.php";

if (isset($_GET['json']) && $_GET['json'] == '1') {
  header("Content-Type: application/json; charset=utf-8");
  $id = (int)($_GET['id'] ?? 0);
  $stmt = $pdo->prepare("SELECT id,status,progress,result_url,error_message FROM song_jobs WHERE id=?");
  $stmt->execute([$id]);
  $job = $stmt->fetch();
  if (!$job) { http_response_code(404); echo json_encode(["error"=>"not_found"]); exit; }
  echo json_encode($job, JSON_UNESCAPED_UNICODE);
  exit;
}

$jobs = $pdo->query("SELECT id,title,style,tempo,status,progress,created_at FROM song_jobs ORDER BY id DESC LIMIT 50")->fetchAll();
?>
<!doctype html>
<html lang="de">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>SongAI – Jobs</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-5">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h3 class="mb-0">🗂️ Meine Jobs</h3>
    <a class="btn btn-primary" href="index.php">+ Neuer Song</a>
  </div>

  <div class="card shadow-sm border-0">
    <div class="table-responsive">
      <table class="table table-hover mb-0 align-middle">
        <thead class="table-light">
          <tr>
            <th>#</th>
            <th>Titel</th>
            <th>Stil</th>
            <th>BPM</th>
            <th>Status</th>
            <th>Progress</th>
            <th>Erstellt</th>
            <th></th>
          </tr>
        </thead>
        <tbody>
        <?php foreach ($jobs as $j): ?>
          <tr>
            <td><?=h((string)$j['id'])?></td>
            <td><?=h((string)$j['title'])?></td>
            <td><?=h((string)$j['style'])?></td>
            <td><?=h((string)$j['tempo'])?></td>
            <td>
              <span class="badge <?= $j['status']==='done'?'bg-success':($j['status']==='failed'?'bg-danger':'bg-secondary') ?>">
                <?=h((string)$j['status'])?>
              </span>
            </td>
            <td><?= (int)$j['progress'] ?>%</td>
            <td><?=h((string)$j['created_at'])?></td>
            <td class="text-end">
              <a class="btn btn-sm btn-outline-secondary" href="result.php?id=<?= (int)$j['id'] ?>">Ansehen</a>
            </td>
          </tr>
        <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
</body>
</html>
