<?php
require_once __DIR__ . "/config.php";

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  http_response_code(405);
  exit("Method not allowed");
}

$raw = file_get_contents("php://input");
$data = json_decode($raw, true);

if (!is_array($data)) { http_response_code(400); exit("Invalid JSON"); }

$jobId = (int)($data['job_id'] ?? 0);
$status = (string)($data['status'] ?? '');
$progress = (int)($data['progress'] ?? 0);
$resultUrl = isset($data['result_url']) ? (string)$data['result_url'] : null;
$errorMessage = isset($data['error_message']) ? (string)$data['error_message'] : null;

$allowed = ['queued','processing','done','failed'];
if ($jobId <= 0 || !in_array($status, $allowed, true)) {
  http_response_code(400);
  exit("Bad request");
}

if ($progress < 0) $progress = 0;
if ($progress > 100) $progress = 100;

$stmt = $pdo->prepare("UPDATE song_jobs SET status=?, progress=?, result_url=?, error_message=? WHERE id=?");
$stmt->execute([$status, $progress, $resultUrl, $errorMessage, $jobId]);

echo "OK";
